C      *****************************************************************
C      * This program is used to test and run the soil model in the    *
C      * absence of the TREGRO model.                                  *
C      *                                                               *
C      * Variables:                                                    *
C      * DcmpDetail-Global- Indicates whether detailed output for      *
C      *                    the decomposition routine should be written*
C      *                    (TRUE) or not (FALSE).  Unitless.          *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * DcmpOut   -Global- The output file number for detailed output *
C      *                    of decomposition routine.  Unitless.       *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * Frstim    -Global- A flag that is a 1 the first time the soil *
C      *                    model is called and is a 0 otherwise.      *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VModel, file VModel.f)       *
C      * GoAhead   -Local - Indicates whether any errors were found.   *
C      *                    (GoAhead=1, no errors found; GoAhead=0,    *
C      *                    errors found.)  Unitless.                  *
C      * I         -Local - Array index.  Unitless.                    *
C      * InputFile -Local - The name of the file to be read in by      *
C      *                    the routine InParam.  Unitless.            *
C      * J         -Local - Array index.  Unitless.                    *
C      * NumRuns   -Local - The number of times the soil chemistry     *
C      *                    model is to be called.  Unitless.          *
C      * StndAlone -Output- Indicates whether soil model is running as *
C      *                    a stand alone model (TRUE) or not (FALSE). * 
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * Tester    -Local - Indicates whether test program or model    *
C      *                    will be run.  Enables programmer to easily *
C      *                    insert a test program if necessary.        *
C      *                    (0 = run model.)  Unitless.                *
C      * YASOut    -Global- The output file number for the YASEQL      *
C      *                    model.  Unitless.                          *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       PROGRAM YASEQL_SE
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INCLUDE 'VGAUSS.INC'
							INTEGER GOAHEAD, I, J, K, NUMRUNS, TESTER
       INTEGER UNITNUM
       CHARACTER*255 INPUTFILE
	   
C      *------------------------------*
C      * Run the soil chemistry model *
C      *------------------------------*
	   
C      *---------------------------------------------------*
C      * Indicate that soil model is an independent model. *
C      *---------------------------------------------------*
       STNDALONE = .TRUE.

C      *------------------------------------------------------------*
C      * Read in interface parameter file which fakes data from the *
C      * tree model.                                                *
C      *------------------------------------------------------------*
       OPEN(UNIT=1, STATUS = "OLD", FILE="INPARAM.DAT")
       READ(1,*) INPUTFILE
       CLOSE(UNIT=1)
       WRITE(6,*) 'Reading file: ', INPUTFILE
       CALL INPARAM(INPUTFILE, TESTER, NUMRUNS)

C      *------------------------------------*
C      * Run the model or the test routines *
C      *------------------------------------*

C      *-----------------------------------------------------------------*
C      * Indicate that detailed output for decomposition is to be output.*
C      *-----------------------------------------------------------------*
       DCMPDETAIL = .TRUE.

C      *------------------------------------------------------*
C      * If the model is to be run, open the output data file *
C      *------------------------------------------------------*
       IF (TESTER.EQ.0) THEN
	         YASOUT = 12
	         OPEN(UNIT = YASOUT, STATUS='NEW', FILE = OUTFILE)
	      ENDIF 

C      *-----------------------------------------------------------------*
C      * Start of Repeat-Until loop (NumRuns completed or program error) *
C      *-----------------------------------------------------------------*
   	   I = 1
  100  CONTINUE		  
          IF (TESTER.EQ.0) THEN
	            CALL SOILCHEM(GOAHEAD)
       	     IF (GOAHEAD.EQ.0) GOTO 9999
             CALL OUTRESULTS(YASOUT, I, NUMRUNS)
	         ELSE
C***             CALL TESTL
	         ENDIF
		        FRSTIM = 0
C         *--------------------------------------------------------*
C         * Save the old theta to be used for water flux movement. *
C         *--------------------------------------------------------*
          DO 200 J=1, NLAYERS
             OLDTHETA(J) = THETA(J)
  200     CONTINUE
	      	  I=I+1
	      IF ((I.LE.NUMRUNS).AND.(GOAHEAD.EQ.1)) GOTO 100
C      *-----------------------*
C      * End Repeat-until loop *
C      *-----------------------*

C      *--------------*
C      * Escape hatch *
C      *--------------*
 9999  CONTINUE
C      *----------------------------------*
C      * If the file was opened, close it *
C      *----------------------------------*
	      IF (TESTER.EQ.0)  CLOSE(UNIT=YASOUT)
       IF (DCMPDETAIL.AND.USEDECOMP)   CLOSE(UNIT=DCMPOUT)
	   
       IF (GOAHEAD.NE.1) THEN
	         WRITE(6,*) 'EXITING WITH ERROR CONDITION'
	      ELSE
	      	  WRITE(6,*) 'EXITING CLEANLY'
       ENDIF

C      *------*
C      * Quit *
C      *------*
       CALL DOMENU("FILE","QUIT")

	      END
C      *****************************************************************
C      *                    END PROGRAM                                *
C      *****************************************************************

